package org.jcon.util.lock;

import java.awt.*;
import java.awt.event.ActionListener;
import java.util.Hashtable;

/**
 * The unit test view. Provides rows of clients
 * that can be edited and started to simulate concurrency
 * contention.   java org.jcon.util.lock.TestView
 *
 * @author Jack Harich
 */
public class TestView {

//---------- Private Fields ------------------------------
private Frame    frame = new Frame("LockPool Unit Test - Demonstrates Concurrency Contention");
private TestViewClient[] clients;

// Key = name, Object = TestViewClient
private Hashtable clientsHash = new Hashtable();

//---------- Initialization ------------------------------
public TestView() {
    //----- Prepare clients
    GridBagConstraints constraints = new GridBagConstraints();
    constraints.gridheight = 1; // One row high
    constraints.gridwidth = GridBagConstraints.REMAINDER;
    constraints.anchor = GridBagConstraints.WEST;

    GridBagLayout gbLayout = new GridBagLayout();
    Panel clientPanel = new Panel();
    clientPanel.setLayout(gbLayout);

    // Label
    Label noteLabel = new Label("   Named Objects, A to Z, 0 to 9");
    gbLayout.setConstraints(noteLabel, constraints);
    clientPanel.add(noteLabel);

    // Rows
    int count = 7;
    clients = new TestViewClient[count];
    for (int i = 0; i < count; i++) {
        // Create client
        String name = "Client" + i;
        clients[i] = new TestViewClient(name);
        clientsHash.put(name, clients[i]);
        // Add to panel
        Component component = clients[i].getComponent();
        gbLayout.setConstraints(component, constraints);
        clientPanel.add(component);
    }
    // Set initial object names - Range A to F
    clients[0].setObjectNames("C E F");
    clients[1].setObjectNames("A C B");
    clients[2].setObjectNames("B C A");
    clients[3].setObjectNames("J K L M N O");
    clients[4].setObjectNames("X Z W K P Y U Q R S");
    clients[5].setObjectNames("1 2 3 4 5");
    clients[6].setObjectNames("6 7 8 9 0");

    //----- Prepare frame
    frame.setBackground(Color.lightGray);
    frame.add("Center", clientPanel);
    frame.pack();
    refreshColorBarCellCount();
}
public static void main(String args[]) {
    new TestView().runUnitTest();
}
//---------- Properties ----------------------------------
public void setController(ActionListener controller) {
    for (int i = 0; i < clients.length; i++) {
        clients[i].setController(controller);
    }
}
public void setVisible(boolean visible) {
    frame.setVisible(visible);
}
//---------- Public Methods ------------------------------
public TestViewClient getClient(String name) {
    return (TestViewClient)clientsHash.get(name);
}
public void runUnitTest() {
    setVisible(true);
}
//---------- Private Methods -----------------------------
private void refreshColorBarCellCount() {
    for (int i = 0; i < clients.length; i ++) {
        clients[i].refreshCellCount();
    }
}
private Button createButton(String text, String command) {
    Button button = new Button(text);
    button.setActionCommand(command);
    return button;
}
//--- Std
private static void print(String text) {
    System.out.println("TestView" + text);
}

} // End class
