package org.jcon.util.lock;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * LockPool unit test and use example.
 *      java org.jcon.util.lock.Test
 *
 * @author Jack Harich
 */
public class Test implements ActionListener {

//---------- Private Fields ------------------------------
private LockPool lockPool = new LockPool();
private TestView view = new TestView();

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new Test().runUnitTest();
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();

    if (command.startsWith("Client")) {
        // Start client since Start button pressed
        TestViewClient viewClient = view.getClient(command);
        TestClient client = new TestClient();
        client.setLockPool(lockPool);
        client.setTestViewClient(viewClient);
        client.setObjectNames(viewClient.getObjectNames());
        client.start();
    }
}
//---------- Public Methods ------------------------------
public void runUnitTest() {
    // Prepare lockPool
    String names = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    for (int i = 0; i < names.length(); i++) {
        String name = names.substring(i, i + 1);
        addTestTask(name);
    }
    // View
    view.setController(this);
    view.setVisible(true);
    // Test HUGE pool
    // *** addExtraTasks();
}
//---------- Private Methods -----------------------------
private void addTestTask(String name) {
    lockPool.add(name, new TestTask());
}
private void addExtraTasks() {
    print(".addExtraTasks() - starting to add 5000 objects: ");
    for (int i = 11; i <= 5000; i++) {
        addTestTask(String.valueOf(i));
        if (i % 100 == 0) System.out.print(" " + i);
    }
    System.out.print("\n");
    print(".addExtraTasks() - done");
}
//--- Std
private static void print(String text) {
    System.out.println("Test" + text);
}

} // End class
