package org.jcon.util.lock;

/**
 * A resource contains a key/object and provides lock
 * properties for that object. Designed for occasions when
 * "synchronized" is inadequate, such as:
 * <p>
 * 1. An arbitrary number of objects need to be locked.
 * <p>
 * 2. The lock needs to surpass the lifetime of the method
 * initiating the lock.
 * <p> <p>
 * To reliably lock and unlock this class the isLocked()
 * and setLocked() methds MUST be called from synchronized
 * sections in the SAME class. Attempting to rely solely  on
 * synchronizing these methods in the Resource class will
 * fail, since the resource pool class will inadvertently
 * block on obtaining the lock.
 *
 * @author Jack Harich
 */

public class Resource implements java.io.Serializable {

//---------- Private Fields ------------------------------
private Object  key;
private Object  object;
private String  sort;
private boolean isLocked;

//---------- Properties ----------------------------------
//----- key
public void setKey(Object key) {
    this.key = key;
}
public Object getKey() {
    return key;
}
//----- object
public void setObject(Object object) {
    this.object = object;
}
public Object getObject() {
    return object;
}
//----- sort
public void setSort(String sort) {
    this.sort = sort;
}
public String getSort() {
    return sort;
}
//----- locked
public void setLocked(boolean locked) {
    isLocked = locked;
}
public boolean isLocked() {
    return isLocked;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("Resource" + text);
}

} // End class
