package org.jcon.util;

/**
 * The interface for TNode listeners. More callbacks to be
 * added as encountered. No event is used so far.
 *
 * @author Jack Harich
 */
public interface TNodeListener {

/**
 * This is called the first time the number of children in
 * a node is needed. The listener should load the children,
 * if any, into this node using insert(). Do not use add()
 * since this triggers the same method that causes this
 * event.
 * <p>
 * After the listener loads the children the tree will
 * proceed as usual, such as displaying those children.
 * <p>
 * See javax.swing.tree.DefaultMutableTreeNode
 * for the example used to figure out how to do this.
 */
public void loadTNodeChildren(TNode parentNode);



} // End interface
