package org.jcon.util;

import java.util.EventObject;
import java.util.Hashtable;

/**
 * This event is delivered whenever a Naming has an object
 * (aka property) changed. Similar to PropertyChangeEvent.
 *
 * It's possible additional behavior may be added to this
 * event, such as notification when the Naming is closing.
 *
 * @author Jack Harich
 */
public class NamingEvent extends EventObject {

//------------ Public Fields -----------------------------
/**
 * The event type constants.
 */
public static final int ADD    = 1;
public static final int CHANGE = 2;
public static final int REMOVE = 3;

//------------ Private Fields ----------------------------
private String objectName;
private int    eventType = 0;
private Object oldValue;
private Object newValue;

//------------ Initialization ----------------------------
/**
 * For constructing an event signifying a change to
 * @param objectName, which should not be null.
 */
public NamingEvent(String objectName, Object source) {
    super(source);
    this.objectName = objectName;

    if (objectName == null) {
        System.out.println("NamingEvent() - objectName should not be "
        + "null, source: " + source.getClass().getName());
    }
}
//---------- Public Methods ------------------------------
/**
 * Returns null if no objectName.
 */
public String getObjectName() {
    return objectName;
}
/**
 * Returns the event type, which is an add, change or remove.
 */
public int getEventType() {
    return eventType;
}
public boolean isAdd() {
    return (eventType == ADD ? true : false);
}
public boolean isChange() {
    return (eventType == CHANGE ? true : false);
}
public boolean isRemove() {
    return (eventType == REMOVE ? true : false);
}
public Object getOldValue() {
    return oldValue;
}
public Object getNewValue() {
    return newValue;
}
//---------- Package Methods -----------------------------
void setEventType(int eventType) {
    this.eventType = eventType;
}
void setOldValue(Object oldValue) {
    this.oldValue = oldValue;
}
void setNewValue(Object newValue) {
    this.newValue = newValue;
}

} // End class
