package org.jcon.util;

import org.jcon.util.msg.MessageRouter;
import java.util.Vector;

/**
 * Provides services for a group of collaborators.
 * Additional services will be added as needed.
 *
 * @author Jack Harich
 */
public class Hub {

//---------- Private Fields ------------------------------
private static MessageRouter globalRouter = new MessageRouter();
private static Naming        globalNaming = new Naming();

private MessageRouter router = new MessageRouter();
private Naming        naming = new Naming();

//---------- Initialization ------------------------------

//---------- Public Methods ------------------------------
//----- Global Services
/**
 * Returns the single global event service.
 *
 * @return the single global router.
 */
public static MessageRouter getGlobalRouter() {
    return globalRouter;
}
/**
 * Returns the single global object broker service.
 *
 * @return the single global Naming service.
 */
public static Naming getGlobalNaming() {
    return globalNaming;
}
//----- Instance Services
/**
 * Returns the event service, the most heavily used service.
 *
 * @return the router for this instance.
 */
public MessageRouter getRouter() {
    return router;
}
/**
 * Returns the object broker service. May be used for
 * properties, service objects, peers, etc.
 *
 * @return the Naming service for this instance.
 */
public Naming getNaming() {
    return naming;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println(text);
}

} // End class
