package org.jcon.util;

/**
 * Various Bean related library methods, all static.
 *
 * @author Jack Harich
 */
public class BeanLib {

//---------- Public Methods ------------------------------
/**
 * Returns the class name without the package. If an array
 * then "[]" is appended as a suffix.
 */
public static String extractDisplayTypeName(Class aClass) {
    // Remove period delimiters
    String name = DataLib.getLastToken(aClass.getName(), ".");
    if (name.endsWith(";")) {
        // Convert String; to String[] for example
        name = name.substring(0, name.length() - 1) + "[ ]";
    }
    return name;
}
/**
 * Same as extractDisplayTypeName() except the package
 * name is preserved.
 */
public static String extractFullDisplayTypeName(Class aClass) {
    String name = aClass.getName();
    if (aClass.isArray()) {
        // Remove first two characters
        name = name.substring(2);
    }
    if (name.endsWith(";")) {
        // Convert String; to String[] for example
        name = name.substring(0, name.length() - 1) + "[ ]";
    }
    return name;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("BeanLib" + text);
}

} // End class
