package org.jcon.ui.tree;

import org.jcon.param.tree.PropList;
import org.jcon.param.tree.PropListConverter;
import org.jcon.param.tree.TestTreeData; 
import org.jcon.param.Param;
import org.jcon.param.ParamConverter;
import org.jcon.ui.VisualLib;
import org.jcon.util.GenLib;
import org.jcon.util.TNode;
import java.awt.Button;
import java.awt.Color;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.*;

/**
 * Test JTreePanel for various. 
 *
 * @author Jack Harich
 */  // java org.jcon.ui.tree.TestBTree
public class TestBTree implements 
    WindowListener, ActionListener {

//---------- Private Fields ------------------------------
private BTree  treePanel = new BTree();
private JFrame frame     = new JFrame();

//---------- Initialization ------------------------------
public static void main(String args[]) {
    VisualLib.installLookAndFeel();
    new TestBTree().runUnitTest();
}
//---------- WindowListener Implementatons ---------------
public void windowClosing(WindowEvent evt) {
    // User clicked on X or chose window Close
    print(".windowClosing() - Entered");
    // frame.dispose();
    // System.out.exit(0);
}
public void windowClosed(WindowEvent evt) { }
public void windowDeiconified(WindowEvent evt) { }
public void windowIconified(WindowEvent evt) { }
public void windowOpened(WindowEvent evt) { }
public void windowActivated(WindowEvent evt) {  }
public void windowDeactivated(WindowEvent evt) { }

//---------- ActionListener Implemented ------------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();
    if (command == "Add") {
        addNode();
    } else if (command == "Remove") {
        removeNode();
    }
}
//---------- Public Methods ------------------------------
public void runUnitTest() {

    // frame prep
    frame.setTitle("Test BTree");
    frame.setBackground(Color.lightGray);
    frame.getContentPane().add("Center", treePanel.getComponent());
    frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
    frame.addWindowListener(this);
    
    // JTree prep
    TestTreeData test = new TestTreeData(); 
    PropList propList = PropListConverter.toPropList(
        test.createHarichFamilyParam());
    treePanel.setRootNode(propList.getRootNode());
    treePanel.setEditable(true);
    
    // *** Severe problems, commented out
    //treePanel.setCellEditor(new TreeCellField2());

    // Left is left of icon, right is correct,
    // No slow click to edit, right double click to edit
//    treePanel.setCellEditor(new DefaultCellEditor(new JTextField()));

    // Button bar
    Panel buttonBar = new Panel();
    buttonBar.add(createButton("Add", "Add"));
    buttonBar.add(createButton("Remove", "Remove"));
    frame.getContentPane().add("South", buttonBar);    

    frame.pack();
    frame.setVisible(true);
}
//---------- Private Methods -----------------------------
private void addNode() {
    TNode parentNode = treePanel.getSelectedNode();
    if (parentNode == null) {
        GenLib.beep();
    } else {
        // Add a child to this node
        TNode newNode = new TNode();
        newNode.setUserObject("New Node");
        parentNode.insertAlphabetically(newNode);
        treePanel.nodeStructureChanged(parentNode);
    }
}
private void removeNode() {
    TNode node = treePanel.getSelectedNode();
    if (node == null) {
        GenLib.beep();
    } else {
        // Remove from tree
        TNode parentNode = (TNode)node.getParent();
        node.removeFromTree();
        treePanel.nodeStructureChanged(parentNode);
    }
}
private Button createButton(String text, String command) {
    Button button = new Button(text);
    button.setActionCommand(command);
    button.addActionListener(this);
    return button;
}
//--- Std
private static void print(String text) {
    System.out.println("TestJTreePanel" + text);
}

} // End class
