package org.jcon.ui.tree;

import org.jcon.util.TNode;

/**
* This class is a polymorphic event from a BTree.
*
* @author Jack Harich
*/
public class BTreeEvent {

//---------- Public Fields -------------------------------
/**
* Signifies a node was selected. The node can
* be obtained with getNode();
*/
public static final int NODE_SELECTED    = 1;

/**
* Indicates a node was "activated", which means
* it was double clicked or ENTER was pressed while the
* node was selected. Obtain the node with getNode().
*/
public static final int NODE_ACTIVATED   = 2;

//---------- Private Fields ------------------------------
// Properties
private int        eventType;
private TNode      node;

//---------- Initialization ------------------------------
public BTreeEvent(int eventType) {
    this.eventType = eventType;
    //    System.out.println("a btree event was created");
}
//---------- Superclass Overrides ------------------------
public String toString() {
    return getEventTypeString();
}
//---------- Properties ----------------------------------
//----- eventType
public int getEventType() {
    return eventType;
}
public String getEventTypeString() {
    if (eventType == NODE_SELECTED) return "NodeSelected";
    if (eventType == NODE_ACTIVATED) return "NodeActivated";
    
    return "#UnknownType#";
}
//----- Object
public void setNode(TNode node) {
    this.node = node;
}
public TNode getNode() {
    return node;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TreeControlEvent" + text);
}

} // End class
