package org.jcon.ui.tree;

import javax.swing.DefaultCellEditor;

/**
 * This class is the tree's cell editor. Due to the
 * questionable design of Swing, we are forced to do all
 * this. A better design is the default edit should NOT 
 * change the node's UserObject.
 *
 * @author Jack Harich
 */
public class BTreeCellEditor extends DefaultCellEditor {

//---------- Private Fields ------------------------------
private BTree bTree;

//---------- Initialization ------------------------------
public BTreeCellEditor(BTree bTree) {
    super(bTree.getTextFieldEditor());
    this.bTree = bTree;
}
//---------- Superclass Overrides ------------------------
/**
* The Javadoc for this is "Returns the value currently
* being edited." The DefaultCellEditor is returning the
* String from the JTextField in the editor, which is terrible.
* We override this to return a more sane value, namely the
* current node.
*/
public Object getCellEditorValue() {
    return bTree.getSelectedUserObject();
}
//---------- Properties ----------------------------------

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("BTreeCellEditor" + text);
}

} // End class
