package org.jcon.ui.texteditor;

import org.jcon.ui.VisualLib;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;

/**
* This class runs a unit test of the test editor and
* demonstrates how to use it.
*/ // java org.jcon.ui.texteditor.UnitTest

public class UnitTest implements ActionListener {
    
//---------- Private Fields ------------------------------
private TextEditor textEditor;

//---------- Initialization ------------------------------
public static void main(String args[]) {
    print(" - Starting test...");
        new UnitTest().start();
    print(" - Test started");
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    if (evt.getActionCommand().equals("SetText")) {
        textEditor.setText("This is line one.\nAnd line two.");   
    }   
}    
//---------- Public Methods ------------------------------
public void start() {
    VisualLib.installLookAndFeel();
    textEditor = new TextEditor();
    
    // Prepare frame
    JFrame frame = new JFrame("This is a Test");
    frame.setBackground(Color.lightGray);
    frame.setSize(300, 400);
    // Config textEditor
    frame.getContentPane().add("North", textEditor.getToolBar());
    frame.getContentPane().add("Center", textEditor.getMainComponent());    
    // Extra test button
    JButton setTextBtn = VisualLib.createCompactButton(
        "Set Text", "SetText", "Calls setText(...)");
    setTextBtn.addActionListener(this);
    textEditor.getToolBar().add(Box.createHorizontalStrut(10)); // Gap
    textEditor.getToolBar().add(setTextBtn);    
    // Show
    frame.setVisible(true);        
} 
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("UnitTest" + text);
}   
    
} // End class    
