package org.jcon.ui.texteditor;

/**
* This class represents a TextEditor event such as
* the document has become dirty. 
* (Add more types and methods as needed)
*/
public class TextEditorEvent {
    
//---------- Public Fields -------------------------------
/**
* Indicates the document has just become dirty.
*/
public static final int TO_DIRTY = 1;

/**
* Indicates the document has just become not dirty..
*/
public static final int TO_CLEAN = 2;

/**
* Indicates the document contents have changed. This is
* regardless of whether the document is dirty or not.
* This is fired very frequently.
*/
public static final int CHANGED = 3;

//---------- Private Fields ------------------------------
private int eventType;

//---------- Initialization ------------------------------
public TextEditorEvent(int eventType) {
    this.eventType = eventType;
}
//---------- Superclass Overrides ------------------------
public String toString() {
    return getEventTypeString();
}
//---------- Properties ----------------------------------
//----- eventType
public int getEventType() {
    return eventType;
}
public String getEventTypeString() {
    if (eventType == TO_DIRTY) return "ToDirty";
    if (eventType == TO_CLEAN) return "ToClean";
    if (eventType == CHANGED) return "Changed";
    return "#UnknownType#";
}
    
} // End class    
