package org.jcon.ui.table;

import javax.swing.table.AbstractTableModel;

/**
 * This abstract class provides a decent default
 * implementation of the TableModel interface, modified to
 * support BTable instead of JTable.
 *
 * @author Jack Harich
 */
public abstract class BTableModel
    extends AbstractTableModel {

//---------- Abstract Implementation ---------------------
public int getColumnCount() {
    return 0; // BTable supplies the columns
}
//---------- Abstract Methods ----------------------------
/**
 * Returns the row count, which may be zero.
 */
public abstract int getRowCount();

/**
 * Returns the Object for the cell at row, column.
 * Currently this should have a toString().
 */
public abstract Object getValueAt(int row, int column);

//---------- Superclass Overrides ------------------------
// Had to override these since protected. It appears that
// protected was used since the designers assumed that
// inheritance would be used to fire the events in
// AbstractTableModel.
// This is a false assumption, since has-a is more common.
public void fireTableDataChanged() {
    super.fireTableDataChanged();
}
public void fireTableRowsInserted(int firstRow, int lastRow) {
    super.fireTableRowsInserted(firstRow, lastRow);
}
public void fireTableRowsUpdated(int firstRow, int lastRow) {
    super.fireTableRowsUpdated(firstRow, lastRow);
}
public void fireTableRowsDeleted(int firstRow, int lastRow) {
    super.fireTableRowsDeleted(firstRow, lastRow);
}

} // End class
