package org.jcon.ui.table;

import org.jcon.ui.VisualLib;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JTextField;

/**
 * An example and unit test of BTable and related classes.
 * NOTE - Double click on cell does NOT start editing.
 *      java org.jcon.ui.table.BTableExample
 *
 * @author Jack Harich
 */
public class BTableExample
    implements BTableListener, ActionListener {

//---------- Private Fields ------------------------------
private JFrame frame = new JFrame("BTable Example");
private BTable table = new BTable();
private Model  model = new Model();

private JTextField statusTxf = new JTextField(20);
private int        rowCount = 3;
private String     data = "Data";

//---------- Initialization ------------------------------
public BTableExample() {
    print(" - Please wait....");
    VisualLib.installLookAndFeel();
    frame.setBackground(Color.lightGray);

    // Prepare BTable
    frame.getContentPane().add("Center", table.getComponent());
    table.setModel(model);
    // *** pack() here causes zero header height
    table.addBTableListener(this);

    table.addColumn(0, 20, "The First Column");
    table.addColumn(1, 15, "Second");
    table.addColumn(2, 10, "Third");
    table.addColumn(3, 25, "The Last Column");

    // MUST pack after adding columns for init() to work
    // Is there a better way???
    frame.pack();
    table.init();

    // 1 row off by 1 pixel
    // 6  rows okay
    table.setNumberRows(2); // 6 okay

    // Prepare button bar
    Panel buttonBar = new Panel();
    buttonBar.add(createButton("Add Data", "AddData"));
    buttonBar.add(createButton("Clear Data", "ClearData"));
    buttonBar.add(createButton("Select 2", "Select2"));
    buttonBar.add(statusTxf);
    frame.getContentPane().add("South", buttonBar);

    // Prepare and show frame
    frame.pack();

    //print(" ---- Before setVisible(true), after second pack()");
    //table.calcPreferredHeight();

    frame.setVisible(true);
}
private Button createButton(String text, String command) {
    Button button = new Button(text);
    button.setActionCommand(command);
    button.addActionListener(this);
    return button;
}
public static void main(String args[]) {
    new BTableExample();
}
//---------- BTableListener Implementation ---------------
public void processBTableEvent(BTableEvent evt) {
    int type = evt.getEventType();
    switch(type) {
        case BTableEvent.ROW_SELECTED:
            setStatus("Row " + evt.getRowIndex() + " selected.");
            break;
        case BTableEvent.ROW_ACTIVATED:
            setStatus("Row " + evt.getRowIndex() + " activated.");
            break;
        default:
            setStatus("Unknown BTableEvent type " + type);
            break;
    }
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();
    if (command == "AddData") {
        rowCount += 2;
        data += "X";
        model.fireTableDataChanged();

    } else if (command == "ClearData") {
        rowCount = 3;
        data = "Data";
        model.fireTableDataChanged();

    } else if (command == "Select2") {
        setStatus("Selected row 2.");
        table.setSelectedRow(2);
    }
}
//---------- Private Methods -----------------------------
private void setStatus(String text) {
    statusTxf.setText(text);
}
//--- Std
private static void print(String text) {
    System.out.println("BTableExample" + text);
}
//========== Inner Classes ===============================
class Model extends BTableModel {
//----- Abstract implementation  -----
public int getRowCount() {
    return rowCount;
}
public Object getValueAt(int row, int col) {
    return data + (++row * ++col);
}
} // End inner class

} // End class
