package org.jcon.ui.table;

import java.util.EventObject;

/**
 * The catchall event fired by BTable. This is an
 * improvement over the several events and listeners
 * required to monitor a JTable.
 *
 * @author Jack Harich
 */
public class BTableEvent extends EventObject {

//---------- Public Fields -------------------------------
public static final int ROW_SELECTED  = 1;
public static final int ROW_ACTIVATED = 2;

//---------- Private Fields ------------------------------
private int eventType;
private int rowIndex;

//---------- Initialization ------------------------------
public BTableEvent(int eventType, int rowIndex, Object source) {
    super(source);
    this.eventType = eventType;
    this.rowIndex = rowIndex;
}
//---------- Superclass Overrides ------------------------
public String toString() {
    return getEventTypeString();
}
//---------- Properties ----------------------------------
//----- eventType
public String getEventTypeString() {
    if (eventType == ROW_SELECTED) return "RowSelected";
    if (eventType == ROW_ACTIVATED) return "RowActivated";

    return "#UnknownType#";
}
public int getEventType() {
    return eventType;
}
//----- Other
public int getRowIndex() {
    return rowIndex;
}

} // End class
