package org.jcon.ui.menu;

import java.util.Hashtable;
import java.util.Vector;

/**
 * Contains a list of MenuItems, such as file or window
 * names, that should be listed at the end of a Menu.
 * This list should only be initialized once, so that a
 * holder can use it to remove old items for example.
 *
 * @author Jack Harich
 */
public class MenuItemListEvent {

//---------- Private Fields ------------------------------
private String    menuName;
private Vector    labels   = new Vector();
private Vector    commands = new Vector();
private Hashtable hashCommands = new Hashtable();

//---------- Public Methods ------------------------------
//----- Initialization
public void setMenuName(String menuName) {
    this.menuName = menuName;
}
public void add(String text, String command) {
    labels.addElement(text);
    commands.addElement(command);
    hashCommands.put(command, "");
}
//----- Retrieval
public String getMenuName() {
    return menuName;
}
public int getItemCount() {
    return labels.size();
}
public String getItemText(int index) {
    return (String)labels.elementAt(index);
}
public String getItemCommand(int index) {
    return (String)commands.elementAt(index);
}
public boolean hasItemCommand(String command) {
    return (hashCommands.get(command) != null ? true : false);
}


} // End class
