package org.jcon.ui.layout;

import java.awt.Component;

/**
* This class is a constraint for use with a 
* StackedBorderLayout. When adding a Component to a
* Container with a StackedBorderLayout, this class MUST
* be used for the constraint argument. 
* See <code> Container.add(Component, Object) </code>.
*
* @author Jack Harich
*/
public class StackedBorderLayoutConstraint {

//---------- Private Fields ------------------------------
private String name;
private String position;
private Component component;

//---------- Properties ----------------------------------
//----- name
/**
* Sets the name of the component, which must be unique
* per Container having the component.
*/
public void setName(String name) {
    this.name = name;
}
public String getName() {
    return name;
}
//----- position
/**
* Sets the BorderLayout position, which must be "North",
* "South", "East", "West" or "Center".
*/
public void setPosition(String position) {
    this.position = position;
}
public String getPosition() {
    return position;
}
//---------- Package Methods ----------------------------
//----- component
/**
* Sets the component being laid out. This is for internal
* use by StackedBorderLayout
*/
void setComponent(Component component) {
    this.component = component;
}
Component getComponent() {
    return component;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("StackedBorderLayoutConstraint" + text);
}

} // End class
