package org.jcon.ui.easylayout;

/**
 * The interface used to implement a custom style library.
 * This is used by the EasyLayoutRegistry and EasyLayout
 * to get styles as requested.
 *
 * @author Jack Harich
 */
public interface EasyLayoutLibrary {

/**
 * Returns the named style. If not found returns null.
 */
public EasyLayoutStyle getStyle(String styleName);

/**
 * Returns the number of styles in the library.
 */
public int getStyleCount();

/**
 * Returns a String array of all style names in the library.
 */
public String[] getStyleNames();


} // End interface
