package org.jcon.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Tests and shows how to use MessageBox.
 * > java org.jcon.ui.MessageBoxTest
 *
 * @author Jack Harich
 */
public class MessageBoxTest implements ActionListener {

//---------- Initialization ------------------------------
public MessageBoxTest(boolean blockWanted) {
    // Apologies, this story is from memory and may be wrong
    String message = "There's an old story called the Lady and the Tiger. ";
    message += "You are placed in an arena with two doors. ";
    message += "Behind one is the farest lady in the land, but ";
    message += "behind the other is a starving tiger. ";
    message += "A friend has told you which door has the lady, ";
    message += "but your rival may have switched doors.";
    message += "\n\nYou must choose a door.";

    MessageBox box = new MessageBox(this);
    box.setTitle("The $64,000 Question");
    box.useImageCanvas("LightBulb.gif");
    box.addChoice("Lady");
    box.addChoice("Tiger");
    box.addChoice("Help");
    box.setCloseWindowCommand("Close");

    if (blockWanted) {
        print("Testing with blocking");
        print(" - before askBlock()");
            print(" - Response = " + box.askBlock(message));
        print(" - after askBlock()");
    } else {
        print("Testing without blocking");
        print(" - before ask()");
            box.ask(message);
        print(" - after ask()");
    }
}
/**
 * With no command line arguments, test without blocking.
 * If any arguments are provided, tests blocking.
 */
public static void main(String args[]) {
    boolean blockWanted = false;
    if (args.length > 0) blockWanted = true;
    new MessageBoxTest(blockWanted);
}
//---------- PactionPerformed Implementation -------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand();

    if (command.equals("Lady")) {
        print("Whoops, there really is a tiger behind the Lady door.");

    } else if(command.equals("Tiger")) {
        print("Ahhh, there really is a lady behind the Tiger door.");

    } else if(command.equals("Help")) {
        print("Help is not yet implemented.  <g>");

    } else if(command.equals("Close")) {
        print("Hmmmm, why take a chance? You choose Close");
    }
    print("     Test complete");
    System.exit(0);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println(text);
}

} // End class
