package org.jcon.ui;

import java.util.EventObject;

/**
 * Represents a request to modify the source of a command.
 * Generally the source will be something firing
 * ActionEvents, Directives or Messages, such as a MenuBar,
 * State Machine, Controller, Button holder, etc.
 *
 * As an example a listener receiving an event with
 * "enabledChanged = true" and "enabled = false"
 * would disable the source of that command. Note
 * that not all event properties are supported by all
 * sources. For example a Button is not toggled.
 *
 * The constructor would be overly complex if all state
 * was set there. Instead the event source should set state
 * and then call makeImmutable(), after which the setter
 * methods are ignored. Thus event listeners cannot change
 * event state.
 *
 * This class may evolve to allow changing the displayed
 * text, such as for a toggle or context behavior. Another
 * future mod is a cookie object.
 *
 * @author Jack Harich - 1st version 88 lines
 */
public class CommandSourceEvent extends EventObject {

//---------- Private Fields ------------------------------
private String command;

private boolean enabled, toggleOn, visible;
private boolean enabledChanged, toggleOnChanged, visibleChanged;
private boolean immutable;

//---------- Initialization ------------------------------
public CommandSourceEvent(Object source, String command) {
    super(source);
    this.command = command;
}
//---------- Public Methods ------------------------------
public String getCommand() {
    return command;
}
public void makeImmutable() {
    immutable = true;
}
//----- enabled property
public void setEnabled(boolean enabled) {
    if (immutable) return;
    this.enabled = enabled;
    enabledChanged = true;
}
public boolean isEnabled() {
    return enabled;
}
public boolean isEnabledChanged() {
    return enabledChanged;
}
//----- toggleOn property
public void setToggleOn(boolean toggleOn) {
    if (immutable) return;
    this.toggleOn = toggleOn;
    toggleOnChanged = true;
}
public boolean isToggleOn() {
    return toggleOn;
}
public boolean isToggleOnChanged() {
    return toggleOnChanged;
}
//----- visible property
public void setVisible(boolean visible) {
    if (immutable) return;
    this.visible = visible;
    visibleChanged = true;
}
public boolean isVisible() {
    return visible;
}
public boolean isVisibleChanged() {
    return visibleChanged;
}


} // End class
