package org.jcon.ui;

// import org.jcon.util.GenLib;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * ColorBar unit test.   java org.jcon.ui.ColorBarTest
 *
 * @author Jack Harich
 */
public class ColorBarTest implements ActionListener {

//---------- Private Fields ------------------------------
private Frame    frame = new Frame("ColorBar Unit Test");
private ColorBar bar = new ColorBar();
private double   percentFull;
private int      fullCount;

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new ColorBarTest().runUnitTest();
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();

    if (command == "Advance") {
        //percentFull += .05;
        //bar.setPercentFull(percentFull);

        // Automatic rollover for fullCount
        fullCount++;
        if (fullCount > bar.getCellCount()) fullCount = 1;

        bar.setFullCount(fullCount);

    } else if (command == "Clear") {
        //percentFull = 0;
        //bar.setPercentFull(percentFull);
        fullCount = 0;
        bar.setFullCount(fullCount);
    }
}
//---------- Public Methods ------------------------------
public void runUnitTest() {
    // Prepare frame, bar
    frame.setBackground(Color.lightGray);
    frame.add("North", bar);

    bar.setCellCount(10);
    bar.setBlinkRate(500);

    // Prepare buttonBar
    Panel buttonBar = new Panel();
    buttonBar.add(createButton("Advance", "Advance"));
    buttonBar.add(createButton("Clear", "Clear"));
    frame.add("South", buttonBar);

    // Reveal
    frame.pack();
    frame.setVisible(true);
}
//---------- Private Methods -----------------------------
private Button createButton(String text, String command) {
    Button button = new Button(text);
    button.setActionCommand(command);
    button.addActionListener(this);
    return button;
}
//--- Std
private static void print(String text) {
    System.out.println("ColorBarTest" + text);
}

} // End class
