package org.jcon.test.widget;

import org.jcon.ui.ImageLib;
import org.jcon.ui.VisualLib;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * Test various for control to simulate hyperlinks.
 * Still need to show underlined text.
 *
 * @author  Jack Harich 
 */ // java org.jcon.test.widget.TestHyperlinkControl
public class TestHyperlinkControl implements
    ActionListener, MouseListener {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new TestHyperlinkControl().runUnitTest();
}
//---------- ActionListener Implementatons ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();
    print(".actionPerformed() - Command = " + command);
    
}
//---------- MouseListener Implementation ----------------
public void mouseClicked(MouseEvent evt) { }
public void mousePressed(MouseEvent evt) { }
public void mouseReleased(MouseEvent evt) { }

// We could also change the font color
public void mouseEntered(MouseEvent evt) {
    JButton link = (JButton)evt.getSource();
    // Show focus
    link.setFocusPainted(true);
    link.requestFocus();
}
public void mouseExited(MouseEvent evt) {
    JButton link = (JButton)evt.getSource();
    // Hide focus
    link.setFocusPainted(false);
}
//---------- Public Methods ------------------------------
public void runUnitTest() {
    print(" - Starting test...");
    VisualLib.installLookAndFeel();
    // Prepare window
    JFrame frame = new JFrame("Test Hyperlink");
    frame.setSize(200, 200);
    
    // Panel of links
    JPanel testPanel = new JPanel();
    //testPanel.setBackground(Color.white); // TEST
    frame.getContentPane().add("Center", testPanel);
    
    createLink(" Link One", "DoThis", testPanel);
    createLink(" Link Two", "DoThat", testPanel);    
    
    // Done
    frame.setVisible(true);
}
//---------- Private Methods -----------------------------
private JButton createLink(String text, String command, JPanel panel) {
    JButton link = new JButton(text);
    link.setActionCommand(command);
    link.addActionListener(this);
    link.addMouseListener(this);
    
    // ----- Simulate link
    // Hide button border
    link.setBorderPainted(false); 
    // Allow background to show through
    link.setContentAreaFilled(false);
    
    provideLinkImage(link);
    panel.add(link);
    
    return link;
}
private void provideLinkImage(JButton link) {
    // Hard coded, later properties
    String className = "org.jcon.ui.image.ImageMarker";
    String resourceName = "Folder.gif";

    Image image = ImageLib.loadClassResourceImage(
        className, resourceName);
    ImageIcon icon = new ImageIcon(image);
    link.setIcon(icon);
}
//--- Std
private static void print(String text) {
    System.out.println("TestHyperlinkControl" + text);
}

} // End class