package org.jcon.test.widget;

import org.jcon.df.edit.control.ButtonBarControl;
import org.jcon.param.Param;
import org.jcon.param.ParamStoreResource;
import org.jcon.ui.VisualLib;
import org.jcon.ui.layout.StackedBorderLayout;
import org.jcon.ui.layout.StackedBorderLayoutConstraint;
import java.awt.BorderLayout;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
* Unit test for ButtonBarControl. <p>
* java org.jcon.test.widget.TestButtonBarControl
*
* @author Jack Harich
*/
public class TestButtonBarControl {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new TestButtonBarControl().runUnitTest1();
}
//---------- Public Methods ------------------------------
public void runUnitTest1() { // StackedBorderLayout
    // Prepare layout
    StackedBorderLayout layout = new StackedBorderLayout();
    StackedBorderLayoutConstraint constraint;
    
    // Prepare window and mainPanel
    VisualLib.installLookAndFeel();
    JFrame window = new JFrame("Test ButtonBarControl");
    JPanel mainPanel = new JPanel();
    mainPanel.setLayout(layout);
    window.getContentPane().add(mainPanel);
    
    // Other regions
    String NAME_CENTER = "TestCenter";
    constraint = new StackedBorderLayoutConstraint();
    constraint.setName(NAME_CENTER);
    constraint.setPosition("Center");
    mainPanel.add(new JButton("Center"), constraint);    
    
    // Test bar in South
    Param param = ParamStoreResource.createParam(this, "TestButtonBarControl.parex");
    ButtonBarControl buttonBar = new ButtonBarControl();
    buttonBar.setParam(param);
    buttonBar.init();
    // Constraint
    String NAME_SOUTH = "TestSouth";
    constraint = new StackedBorderLayoutConstraint();
    constraint.setName(NAME_SOUTH);
    constraint.setPosition("South");
    mainPanel.add(buttonBar.getComponent(), constraint);
    
    Vector names = new Vector();
    names.addElement(NAME_CENTER);
    names.addElement(NAME_SOUTH);
    layout.showComponents(names);
    
    // Done
    window.setSize(300, 150);
    window.setVisible(true);
}
public void runUnitTest2() { // BorderLayout
    // Prepare window and mainPanel
    VisualLib.installLookAndFeel();
    JFrame window = new JFrame("Test ButtonBarControl");
    JPanel mainPanel = new JPanel();
    mainPanel.setLayout(new BorderLayout());
    window.getContentPane().add(mainPanel);
    // Test bar in South
    Param param = ParamStoreResource.createParam(this, "TestButtonBarControl.parex");
    ButtonBarControl buttonBar = new ButtonBarControl();
    buttonBar.setParam(param);
    buttonBar.init();
    mainPanel.add(buttonBar.getComponent(), "South");
    // Done
    window.setSize(300, 150);
    window.setVisible(true);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TestButtonBarControl" + text);
}

} // End class