package org.jcon.test.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * Test various on a JFrame. - CardLayout problem
 * This is a very poorly designed part of the awt.
 * <p>
 * Tests fine. Button appears where and how it should.
 * CardLayout is honoring layout requests correctly.
 *
 * @author Jack Harich 2/10/99
 */  // java org.jcon.test.ui.Frame1
public class Frame1 {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new Frame1().runUnitTest();
}
//---------- Public Methods ------------------------------
public void runUnitTest() {
    JFrame window = new JFrame("Test Frame");
    CardLayout cardLayout = new CardLayout();
    // Put card panel in window
    JPanel cardPanel = new JPanel();
    cardPanel.setLayout(cardLayout);
    window.getContentPane().add(cardPanel, "Center");
    // Create a panel with BorderLayout, put in window
    JPanel borderPanel = new JPanel();
    borderPanel.setLayout(new BorderLayout());
    cardPanel.add("Border", borderPanel);
    // Put something on borderPanel
    borderPanel.add(new JButton("North"), "North");
    // Done
    window.pack();
    window.setVisible(true);
    cardLayout.show(cardPanel, "Border");
}
//---------- Private Methods -----------------------------
//--- Std
private void print(String text) {
    System.out.println("Frame1" + text);
}


} // End class