package org.jcon.test.screen.autotest;

import org.jcon.ui.OutputConsole;
import org.jcon.ba.system.ItemSystemMgr;

/**
* The AutoTest system entry point and marker class.
* This tests another system that uses the Modular Screen
* Subsystem. 
* <p>
* To run a test, start the BA Editor. Then start the system
* to be tested. Then start the AutoTest system that tests
* that system. The two systems MUST be in the same process.
*
* @author Jack Harich
*/  // java -nojit org.jcon.test.screen.autotest.StartSystem
public class StartSystem {
    
//---------- Initialization ------------------------------
// Any arg to open console
public static void main(String args[]) {
    System.out.println("Starting system...");
    if (args.length > 0) {
        new OutputConsole().setVisible(true);
    }    
    // Start sytsem
    new ItemSystemMgr().startSystem(new StartSystem(), args);
}


} // End class