package org.jcon.test.rmi;

import java.rmi.Naming;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.registry.LocateRegistry;

/**
 * ----- To run unit test: -----
 *
 * Generate the Skel and Stub files if necessary:
 * >rmic org.jcon.test.rmi.Datastore
 *
 * >java Datastore (on the server - must do before client)
 * >java DatastoreServices (a unit test)
 *
 * Start this class with something like: <pre>
 * >java -Djava.rmi.server.logCalls=true
 *       -Djava.rmi.server.codebase=http://sheba/awork/
 *       -classpath .;C:\Java\Lib\Classes.zip;C:\Apps\Apache\htdocs\awork;C:\JP\Swing.jar
 *       org.jcon.test.rmi.StartServer
 * </pre>
 *
 * Note - For local testing TCP may need to be enabled by:
 * Dialup Networking, TCP/IP Properties, check "Specify an IP Address",
 * IP Address 192 168 1 1, Subnet Mask 255 255 255 0.
 * This allows an IP address reserved for non Internet use
 * to be used locally.
 *
 * @author Jack Harich
 */
public class StartServer {

//---------- Private Fields ------------------------------
private static String   remoteName = "DatastoreRemote";
private static boolean  bound;

//---------- Initialization ------------------------------
public static void main(String args[]) {
    // TEST *** No help and no effect
    //remoteName = "rmi://sheba/DatastoreRemote";

    if (args.length > 0) remoteName = args[0];
    new StartServer().bindToRemoteRegistry();
}
//---------- Public Methods ------------------------------
public void bindToRemoteRegistry() {
    if (bound) return;
    try {
        // Install security manager
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        // Start registry
        int PORT = 1099;
        print(" - Creating registry on port " + PORT);
        LocateRegistry.createRegistry(PORT);

        // Bind myself
        print(" - Binding '" + remoteName + "', please wait....");
        Naming.rebind(remoteName, new Datastore());

        // Done
        print(" - Binding complete. Datastore is ready as a remote object.");
        bound = true;

    } catch(Exception ex) {
        print("Failure rebinding '" + remoteName + "'.");
        ex.printStackTrace();
    }
}
//---------- Private Methods -----------------------------
//--- Std
private void print(String text) {
    System.out.println("StartServer" + text);
}

} // End class
