package org.jcon.test.rmi;

//import org.jcon.ui.OutputConsole;
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

/**
 * An applet entry point. It relies on the browser
 * classloader to provide server classes and stubs.
 *
 * @author Jack Harich
 */
public class EntryPoint1 extends Applet
    implements ActionListener {

//---------- Private Fields ------------------------------
private Frame frame = new Frame("Test Frame");

// Console causes applet securty exception
//private OutputConsole console = new OutputConsole();

//---------- Superclass Overrides ------------------------
public void init() {
    print(".init() entered");

    add(createButton("Frame",       "Frame"));
    add(createButton("Bootstrap",   "Bootstrap"));
    add(createButton("Entry Point", "EntryPoint"));
    add(createButton("Start ATSDR Client", "StartATSDRClient"));

    frame.setSize(200, 300);
}
public void start() {
    print(".start() entered");
    //console.setVisible(true);
}
public void stop() {
    print(".stop() entered");
}
public void destroy() {
    print(".destroy() entered");
    frame.dispose();
    //console.destroy();
}
public void paint(Graphics g) {
    g.drawString("sdfsdf", 5, 5);
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();
    print(".actionPerformed() - command = " + command);

    if (command == "Frame") {
        frame.setVisible(true);

    } else if (command == "Bootstrap") {
        print(".actionPerformed() - About to run Bootstrap");
        new Bootstrap().runClass();

    } else if (command == "EntryPoint") {
        print(".actionPerformed() - About to run EntryPoint");
        new EntryPoint().run();

    } else if (command == "StartATSDRClient") {
        print(".actionPerformed() - About to start ATSDR client");
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.setClassName("gov.cdc.atsdr.client.EntryPoint");
        bootstrap.runClass();
    }
}
//---------- Private Methods -----------------------------
private Button createButton(String text, String command) {
    Button button = new Button(text);
    button.setActionCommand(command);
    button.addActionListener(this);
    return button;
}
//--- Std
private static void print(String text) {
    System.out.println("EntryPoint1" + text);
}

} // End class
