package org.jcon.test.comm;

import org.jcon.util.GenLib;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;

/**
 * This class handles a test server socket.
 *
 * @author Jack Harich
 */
public class CommServerTestHandler implements Runnable {

//---------- Private Fields ------------------------------
private Socket           socket;
private boolean          running;
private DataOutputStream outStream;
private DataInputStream  inStream;
private String           testName = "The Wizard of Oz";

//---------- Initialization ------------------------------
public CommServerTestHandler(Socket socket) {
    this.socket = socket;   
}    
//---------- Runnable Implementation ---------------------
// Simulate a server
public void run() { 
    try {
        //----- Prepare for client conversation
        running = true;
        // Note - Hangs if inStream first
        outStream = new DataOutputStream(socket.getOutputStream());
        inStream  = new DataInputStream(socket.getInputStream());        
        
        //----- Receive commands from client
        int    command;
        String text;
        while(running) {
            try {
                // Await command
                command = inStream.readInt();                       
                // Await value
                text = inStream.readUTF();
            } catch(EOFException ex) {
                // Client has closed unexpectedly
                print(" - Client closed detected");
                running = false;
                break;
            }
            // Process command
            String result = processCommand(command, text);
            // Return result if still running
            // For example if command is signoff we are not longer running
            // Note null text will cause exception
            if (running && result != null) outStream.writeUTF(result);
        }
        //----- Close socket
        outStream.close();
        inStream.close();
        socket.close();
        
    } catch(IOException ex) {
        GenLib.exception("CommServerTestHandler.run()",
            "Failure while running.", ex);
    }
} 
//---------- Public Methods ------------------------------
public void start() {
    new Thread(this).start();   
}    
//---------- Private Methods -----------------------------
private String processCommand(int command, String text) {
    String result = null;
    
    switch(command) {
        case CommServerTest.GET_NAME:
            result = testName;
            break;
            
        case CommServerTest.SET_NAME:
            testName = text;
            break;            
            
        case CommServerTest.SIGNOFF:
            print(" - Client signoff");
            running = false;
            break;    
    }
    return result;
}
//--- Std
private static void print(String text) {
    System.out.println("CommServerTestHandler" + text);
}

} // End class
