package org.jcon.test.comm;

import org.jcon.util.GenLib;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;

/**
 * Unit test and use example for CommServer and CommClient.
 * <p>
 * Test - java org.jcon.test.comm.CommServerTest
 *
 * @author Jack Harich
 */
public class CommServerTest implements CommServerUser {

//---------- Public Fields -------------------------------
public static final int PORT     = 8000;
public static final int GET_NAME = 1;
public static final int SET_NAME = 2;
public static final int SIGNOFF  = 3;

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new CommServerTest().start();            
}    
//---------- CommServerUser Implementation ---------------
public void socketAccepted(Socket socket) {
    CommServerTestHandler handler = new CommServerTestHandler(socket);
    handler.start();
}
//---------- Public Methods ------------------------------
public void start() {
    print(" - Starting server on port " + PORT);
    CommServer server = new CommServer();
    server.setPort(PORT);
    server.setCommServerUser(this);
    server.start();
    print(" - CommServer started and awaiting clients");
}    
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("CommServerTest" + text);
}

} // End class
