package org.jcon.test.comm;

import java.io.IOException;

/**
 * The unit test and use example for CommClient.
 * <p>
 * Test - java org.jcon.test.comm.CommClientTest
 *
 * @author Jack Harich
 */
public class CommClientTest {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new CommClientTest().start();   
}    
//---------- Public Methods ------------------------------
public void start() {
    
print(" --- Starting test, localhost, port = " + CommServerTest.PORT);
CommClient client = new CommClient();
client.setPort(CommServerTest.PORT);
client.setHost("localhost");

String name;
try {        
    // Get name - Failure if null value ***
    name = client.sendStringReply(CommServerTest.GET_NAME, null);
    print(" - get name = " + name);
    
    // Set name, no reply
    client.sendString(CommServerTest.SET_NAME, "New name");
    
    // Wait 5 seconds to test timeout
    try {
        Thread.currentThread().sleep(5000);
    } catch(InterruptedException ex) {
        print(".start() - Interrupted, should not happen");   
    }
        
    // Get changed name
    name = client.sendStringReply(CommServerTest.GET_NAME, null);
    print(" - get name = " + name);
        
    // Signoff, no reply
    client.sendString(CommServerTest.SIGNOFF, null);
    print(" - signed off "); 
     
} catch(IOException ex) {
    ex.printStackTrace();
}       
print(" --- Test complete");  
    
} // End method
     
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("CommClientTest" + text);
}

} // End class
