package org.jcon.test;

import java.awt.*;
import org.jcon.ui.WindowLib;

/**
 * Test main menu for bug. Unable to set proper height if
 * too many menus.  java org.jcon.test.TestMainMenu
 * Notes: <pre>
 * - doLayout() and no pack() leaves insets 0
 *
 * @author Jack Harich
 */
public class TestMainMenu {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new TestMainMenu().runTest();
}
//---------- Public Methods ------------------------------
public void runTest() {
    Frame  frame = new Frame();
    frame.setBackground(Color.lightGray);
    frame.setTitle("Test Main Menu");

    // Create and set MenuBar
    MenuBar menuBar = new MenuBar();
    menuBar.add(new Menu("First"));
    //menuBar.add(new Menu("Second"));
    //menuBar.add(new Menu("Third"));
    //menuBar.add(new Menu("Fourth"));
    //menuBar.add(new Menu("Fifth"));
    frame.setMenuBar(menuBar);

    // Set frame width and height to "main menu" style
    frame.pack();
    Insets insets = frame.getInsets();
    print("insets.top = " + insets.top);
    print("WindowLib.getMainMenuHeight() = " + WindowLib.getMainMenuHeight());

    // Use fixed width and calculated height
    frame.setSize(300, WindowLib.getMainMenuHeight());

    // Done
    frame.setVisible(true);
}

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println(text);
}

} // End class
