package org.jcon.test;

import java.awt.*;

/**
 * Test a problem with preferred height of lightweight in
 * "North" BorderLayout. The component is not showing.
 * java org.jcon.test.TestLightwight
 * Isolated Java 1.1.5 bug, see commented out line 60.
 *
 * @author Jack Harich 4/22/98
 */
public class TestLightwight {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new TestLightwight().runUnitTest();
}
//---------- Public Methods ------------------------------
public void runUnitTest() {
    Frame frame = new Frame("TestLightwight");
    frame.setBackground(Color.lightGray);
    frame.add("North", new Bar());
    frame.pack();
    frame.setVisible(true);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TestLightwight" + text);
}

} // End class

//========== Other Classes ===============================
class Bar extends Component {

//---------- Private Fields ------------------------------
private int prefWidth  = 200;
private int prefHeight = 20;

//---------- Superclass Overrides ------------------------
// The crucial method - Horizontal version
public void paint(Graphics g) {
    Rectangle b = getBounds();
    // Draw border
    g.setColor(Color.black);
    g.drawRect(0, 0, b.width - 1, b.height - 1);
}
//----- These methods allow control of our size, with default
public void setSize(int width, int height) {
    print(".setSize() - Entered, width = " + width + ", height = " + height);
    setBounds(getLocation().x, getLocation().y, width, height);
    super.setSize(width, height);
}
public void setBounds(int x, int y, int width, int height) {
    print(".setBounds() - Entered, width = " + width + ", height = " + height);
    super.setBounds(x, y, width, height);
    prefWidth = width;
    // ****** Comment out next line to work okay
//    prefHeight = height;
    repaint();
}
public Dimension getPreferredSize() {
    print(".getPreferredSize() - Entered, prefWidth = " +
        prefWidth + ", prefHeight = " + prefHeight);
    return new Dimension(prefWidth, prefHeight);
}
public Dimension getMinimumSize() {
    print(".getMinimumSize() entered");
    return getPreferredSize();
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TestLightwight" + text);
}


} // End class
