package org.jcon.test;

import java.awt.Dimension;
import java.awt.TextArea;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.*;

/**
 * Tests for max String size supported. Result - JTextArea
 * is full of bugs. TextArea cannot hold long String, such
 * as EditAwards.parex.
 * <p>
 * Also tests WindowEvent for when app loses focus.
 * Result - Activated and Deactivated work fine, and are
 * emitted when Iconified and Deiconified. This is good.
 *
 * @author  Jack Harich 
 */ // java org.jcon.test.TestJTextArea
public class TestJTextArea implements WindowListener {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    int fillCount = 7;
    if (args.length > 0) fillCount = Integer.parseInt(args[0]);
    new TestJTextArea().runUnitTest(fillCount);
}
//---------- WindowListener Implementatons ---------------
public void windowClosing(WindowEvent evt) {
    // User clicked on X or chose window Close
}
public void windowClosed(WindowEvent evt) { }
public void windowDeiconified(WindowEvent evt) {
    print(".windowDeiconified()");
}
public void windowIconified(WindowEvent evt) {
    print(".windowIconified()");
}
public void windowOpened(WindowEvent evt) { }
public void windowActivated(WindowEvent evt) {
    print(".windowActivated()");
}
public void windowDeactivated(WindowEvent evt) {
    print(".windowDeactivated()");
}
//---------- Public Methods ------------------------------
public void runUnitTest(int fillCount) {
    // Create view
    JFrame frame = new JFrame("Test JTextArea");
    frame.addWindowListener(this);

    TextArea textArea = new TextArea("", 1, 1,
        TextArea.SCROLLBARS_BOTH);
    //textArea.setLineWrap(true);
    //textArea.setPreferredSize(new Dimension(300, 400));

    JScrollPane scrollPane = new JScrollPane(textArea);

    frame.getContentPane().add("Center", scrollPane);
    frame.pack();
    frame.setVisible(true);
    // Fill up
    fillWithString(textArea, fillCount);
}
public void fillWithString(TextArea textArea, int fillCount) {
    // Max size? Out of memory at 1MB, default memory size.
    String chunk = "";
    String ten = "1234567890";

    for (int i = 1000; --i >= 0;) {
        chunk += ten;
    }

    String text = "";
    for (int i = 1; i <= fillCount; i++) {
        text += chunk;
        print("length = " + text.length());
        textArea.setText(text);
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println(text);
}

} // End class
