package org.jcon.test;

import java.sql.*;

/**
 * Simple JDBC test to determine if JDBC is working.
 * java org.jcon.test.TestJDBC
 *
 * @author Jack Harich
 */
public class TestJDBC {

//---------- Private Fields ------------------------------
private Connection connection;
private Statement statement;

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new TestJDBC().runUnitTest();
}
//---------- Properties ----------------------------------
public Statement getStatement() {
    if (statement == null) {
        try {
        // Register driver
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        // Establish connetion (Database, UserID, Password)
        connection = DriverManager.getConnection(
            "jdbc:odbc:atsdr2", "Admin", "");
        // Get statement
        statement = connection.createStatement();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    return statement;
}
public void close() {
    try {
        if (statement != null) statement.close();
        if (connection != null) connection.close();
    } catch (Exception ex) {
        ex.printStackTrace();
    }
}
//---------- Events --------------------------------------

//---------- Public Methods ------------------------------
public void runUnitTest() {
    TestJDBC tester = new TestJDBC();
    Statement statement = tester.getStatement();
    if (statement == null) print("Problem - statement is null");
    testSQL(statement); // <-----<<<
    tester.close();
    print("Test complete");
}
// Test SQL problem
public void testSQL(Statement statement) {
    String sql = "SELECT " +
    "Award.SubmittingEmpAdminCode, " +
    "Award.Reason, " +
    "Award.ProposedAmount, " +
    "Award.SubmittingEmpDivOffice, " +
    "Award.MID, " +
    "Award.DateClosed, " +
    "Award.FiscalYear, " +
    "Award.AwardTypeMID, " +
    "Award.LastUserSysMID, " +
    "Award.AwardStatusMID, " +
    "Award.ApprovedAmount, " +
    "Award.SubmittingEmpName, " +
    "Award.DateInitiated, " +
    "Award.TStamp " +
    "FROM Award WHERE Award.FiscalYear=1997 " +
    "ORDER BY DateInitiated";
    try {
        ResultSet resultSet = statement.executeQuery(sql);
        // Count number rows returned
        int count = 0;
        while (resultSet.next()) {
            count++;
        }
        print(" - " + count + " rows returned");

    } catch(SQLException ex) {
        ex.printStackTrace();
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TestJDBC" + text);
}

} // End class
