package org.jcon.test;

import org.jcon.param.*;
import org.jcon.ui.OutputConsole;
import org.jcon.util.BenchMark;
import org.jcon.util.GenLib;

/**
 * Test how to optimize large Param loads.
 * java org.jcon.test.TestEditFieldsParam
 *
 * @author Jack Harich
 */

public class TestEditFieldsParam implements Runnable {

//---------- Private Fields ------------------------------
private ParamStoreResource paramStore = new ParamStoreResource();

//---------- Initialization ------------------------------
public TestEditFieldsParam(String args[]) {
    new OutputConsole().setVisible(true);
    // Prep
    Object marker = GenLib.createInstance("gov.cdc.atsdr.client.DataClient");
    String resource = "awards/edit/EditAwards.parex";

    ParamAccessor accessor = new ParamAccessor();
    accessor.setMarkerClass(marker);
    accessor.setResourceName(resource);

    // Create Params
    print("Creating Params from " + resource);
    Param[] params = createMany(accessor);

    //print("param = " + params[0]);

    // Prevent end process for OptomizeIt
    // *** run();
    // old new Thread(this).start();
}
public static void main(String args[]) {
    new TestEditFieldsParam(args);
    print("Leaving main()");
}
//---------- Runnable Implementation ---------------------
public synchronized void run() {
    // Prevent end process
    print("Waiting forever");
    try {
        //Thread.currentThread().sleep(9000000);
        wait();
    } catch(InterruptedException ex) {
        print("Interrupted");
    }
}
//---------- Private Methods -----------------------------
/**
 *    Telltale results - No console, with console
 *    All with no System.gc()
 *    With intern() down to 35.37
 *               JDK    S JIT
 * 1st 3.62     4.23    3.30
 * 2nd 5.38     6.59    2.69
 * 3rd 7.91     8.62    2.58
 * 4th 8.02     8.13    2.80
 * 5th 8.13     8.46    2.92
 * Tot         36.03   14.34
 * Total 3.57 with StringBuffer()
 */
private Param[] createMany(ParamAccessor accessor) {
    print("Starting createMany() - " + BenchMark.startTimeSeries(0));
    Param[] params = new Param[5]; // *** Normal 5
    for (int i = 0; i < params.length; i++) {
        params[i] = paramStore.readParam(accessor);
        print("Created " + i + " - " + BenchMark.getTimeElapsed(0));
        //System.gc();
    }
    print("Done, total time = " + BenchMark.getTimePoint(0)); // 3.57 seconds ******
    return params;
}
//--- Std
private static void print(String text) {
    System.out.println(text);
}

} // End class
