package org.jcon.test;

import java.rmi.*;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;

/**
 * Tests RMI binding. Can optionally enter port as first
 * command line argument, such as 8000.
 *
 * @author Jack Harich // java org.jcon.test.TestBind
 */
public class TestBind extends UnicastRemoteObject
    implements TestBindRemote {

//---------- Initialization ------------------------------
public TestBind() throws RemoteException {
    super(); // Required
}
public static void main(String args[]) {
    int PORT = 1099;
    if (args.length > 0) PORT = Integer.parseInt(args[0]);
    try {
        //--- Install security manager
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        //--- Start registry, ignore if port already in use since that's the registry
        try {
            print(" - Creating registry on port " + PORT);
            LocateRegistry.createRegistry(PORT);
        } catch(Exception ex) {
            print("Ignoring " + ex.getMessage());
        }    
        //--- Bind TestBind instance
        print(" - Binding, please wait.");
            Naming.rebind("Test1", new TestBind());
        print(" - Binding complete");
        
        //--- Retreive via rmi Naming
        TestBindRemote retreived = (TestBindRemote)Naming.lookup("Test1");
        print(" - Retreived " + retreived);

    } catch(Exception ex) {
        print(".main() Exception");
        ex.printStackTrace();
    }
}
//---------- TestBindRemote Implementation ---------------
public String getName() throws RemoteException {
    return "MyName";
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TestBind" + text);
}

} // End class
