package org.jcon.test;

// import org.jcon.util.GenLib;
import java.awt.*;
import java.awt.event.*;

/**
 * Tests the tendency of a modal Dialog to cause deadlock
 * unless setVisible(true) is called in a different thread.
 * Apparently this awt bug fixed by or before 1.1.3.
 *
 * @author Jack Harich
 */
public class TestAWTDeadlock implements
    ActionListener, Runnable {

//---------- Private Fields ------------------------------
private Frame  frame = new Frame("Test Deadlock");
private Dialog dialog;

//---------- Initialization ------------------------------
public TestAWTDeadlock() {
    // Configure frame
    frame.setBackground(Color.lightGray);
    frame.setSize(300, 150);
    // Add button bar
    Panel buttonBar = new Panel();
    frame.add("South", buttonBar);
    // Deadlock button
    buttonBar.add(createButton("No Deadlock", "OpenDialogNoDeadlock"));
    buttonBar.add(createButton("Deadlock", "OpenDialogDeadlock"));
    // Done
    frame.setVisible(true);
}
public static void main(String args[]) {
    new TestAWTDeadlock();
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();

    if (command == "OpenDialogDeadlock") {
        openDialog(true);

    } else if (command == "OpenDialogNoDeadlock") {
        openDialog(false);

    } else if (command == "CloseDialog") {
        // Never called if deadlocked <-----<<<
        print(" - Close from dialog received");
        dialog.dispose();
        dialog = null;
    }
}
//---------- Runnable Implementation ---------------------
public void run() {
    dialog.setVisible(true);
}
//---------- Private Methods -----------------------------
private void openDialog(boolean deadlockWanted) {
    // Prepare modal dialog
    dialog = new Dialog(frame, true); // true for modal
    String suffix = (deadlockWanted ? "Deadlock" : "No Deadlock");
    dialog.setTitle(suffix + " Dialog");
    dialog.setSize(200, 150);
    dialog.setLocation(0, 175);
    // Add button bar
    Panel buttonBar = new Panel();
    dialog.add("South", buttonBar);
    // Close button
    buttonBar.add(createButton("Close", "CloseDialog"));
    // The crucial call
    print(" - Before dialog.setVisible(true)");
    if (deadlockWanted) {
        // Should cause deadlock <-----<<<
        print(" - Should cause deadlock");
        dialog.setVisible(true);
    } else {
        // No deadlock since we allow the awt thread to continue
        // Note this method is called in the awt thread when
        // a button was clicked.
        print(" - Should NOT cause deadlock");
        new Thread(this).start();
    }
    print(" - After dialog.setVisible(true)");
}
private Button createButton(String text, String command) {
    Button button = new Button(text);
    button.setActionCommand(command);
    button.addActionListener(this);
    return button;
}
//--- Std
private static void print(String text) {
    System.out.println("TestAWTDeadlock" + text);
}

} // End class
