package org.jcon.test;

import java.net.URL;
import java.io.*;
import java.rmi.RMISecurityManager;

/**
 * Test read URL ability. This is an old class than may be
 * useful. It needs to be property driven.
 *
 * @author Jack Harich
 */
public class ReadURL {

//---------- Private Fields ------------------------------
// (none)

//---------- Initialization ------------------------------
public static void main(String args[]) {
    // *** No help
    //System.setSecurityManager(new RMISecurityManager());

    String urlString = "http://bbs.atsdr.cdc.gov/jp/EntryPoint.java";
    if (args.length > 0) urlString = args[0];
    new ReadURL(urlString);
}
public ReadURL(String urlString) {
try {
   // Read a text file given it's URL
URL url = new URL(urlString);

    InputStream inputStream = (InputStream)url.getContent();
    printSomeLines(inputStream);
    inputStream.close();
    print("\nJust printed url: " + url.toString() );
    System.exit(0);

} catch(Exception ex) {
    print("TestURL() exception");
    ex.printStackTrace();
}

} // End method
//---------- Public Methods ------------------------------
// (none)

//---------- Private Methods -----------------------------
// This shows if we got the text file
private void printSomeLines(InputStream input) throws IOException {
    InputStreamReader inReader = new InputStreamReader(input);
    BufferedReader reader = new BufferedReader(inReader);

    String line = reader.readLine();
    if (line != null) print(line);
    int count = 1;
    while (line != null) {
        line = reader.readLine();
        if (line != null) print(line);
        if (++count > 6) break;
    }
    reader.close();
}
//--- Std
private void print(String text) {
    System.out.println(text);
}

} // End class
