package org.jcon.test;

import org.jcon.param.Param;
import org.jcon.param.ParamAccessor;
import org.jcon.param.ParamStoreResource;
import org.jcon.ui.OutputConsole;
import org.jcon.util.GenLib;

/**
 * Simulate a Param conversion problem for debugging.
 * Turned out to be bug in Swing 1.1B2 tab widget
 *
 * @author Jack Harich
 */   // java org.jcon.test.ParamProblem
public class ParamProblem {

//---------- Private Fields ------------------------------

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new OutputConsole().setVisible(true);
    new ParamProblem().test(
        "org.jcon.test.app3.Client3", "EditTest3.parex");
}
//---------- Public Methods ------------------------------
public void test(String className, String resourceName) {
    print(".test() ----- Starting test");
    
    // Create the test Param
    ParamAccessor accessor = new ParamAccessor();
    accessor.setMarkerClass(GenLib.createInstance(className));
    accessor.setResourceName(resourceName);    
    Param param = new ParamStoreResource().readParam(accessor);    
    
    // Show the param's original text.
    print(" - param original text = \n" + param);    
    
    // Show built text
    param.buildText();
    print(" - param built text = \n" + param);  
    
      
print(".test() ----- Test complete");
}
//---------- Private Methods -----------------------------

//--- Std
private static void print(String text) {
    System.out.println("ParamProblem" + text);
}

} // End class
