package org.jcon.test;

import org.jcon.ba.system.BeanActionClose;
import org.jcon.ui.WindowLib;
import java.awt.*;

/**
 * An enhanced Frame extension for Param driven use.
 * *** in evolution
 *
 * @author Jack Harich
 */
public class ParamFrame extends Frame
    implements BeanActionClose {

//---------- Private Fields ------------------------------
private boolean sizeSet = false;

//---------- Superclass Overrides ------------------------
public void setSize(int width, int height) {
    super.setSize(width, height);
    sizeSet = true;
}
//---------- BeanActionClose Implementation --------------
public String canClose() {
    return null; // null means yes I can close
}
public void close() {
    this.dispose();
}
//---------- Properties ----------------------------------
public void setMainPanel(Panel mainPanel) {
    this.setBackground(Color.lightGray);
    this.add("Center", mainPanel);
    if (! sizeSet) this.pack();
    WindowLib.center(this);
}
//---------- Events --------------------------------------

//---------- Public Methods ------------------------------

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("GeneralFrame" + text);
}

} // End class
