package org.jcon.test;

// import org.jcon.util.GenLib;
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

/**
 * A simple test Applet to test the Java Plugin.
 *
 * @author Jack Harich
 */
public class JavaPlugIn extends Applet
    implements ActionListener {

//---------- Private Fields ------------------------------
private Frame frame = new Frame("Test Frame");

//---------- Superclass Overrides ------------------------
public void init() {
    print(".init() entered");

    add(createButton("Open Frame", "OpenFrame"));
    add(createButton("Start App (later)", "StartApp"));

    frame.setSize(200, 300);
}
public void start() {
    print(".start() entered");
}
public void stop() {
    print(".stop() entered");
}
public void destroy() {
    // Called when Plugin page changed
    print(".destroy() entered");
    frame.dispose();
}
public void paint(Graphics g) {
    g.drawString("sdfsdf", 5, 5);
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();
    print(".actionPerformed() - command = " + command);

    if (command == "OpenFrame") {
        frame.setVisible(true);

    } else if (command == "StartApp") {
        // *** Not yet implemented
    }
}
//---------- Private Methods -----------------------------
private Button createButton(String text, String command) {
    Button button = new Button(text);
    button.setActionCommand(command);
    button.addActionListener(this);
    return button;
}
//--- Std
private static void print(String text) {
    System.out.println("JavaPlugIn" + text);
}

} // End class
