package org.jcon.param.util.build;

/**
* The interface for BuildParamEvent listeners.
*
* @author Jack Harich
*/
public interface BuildParamListener {


/**
* The listener should return the array of keys it is
* interested in. For example it might return "LookupATSDR"
* in an array.
*
* @return  the array of keys the listener is interested in
* or a zero length array if none.
*/
public String[] getBuildParamKeys();


/**
 * The listener should process the event. If the event
 * is unwanted it may complain but should not throw an
 * exception.
 *
 * @param evt  the event, which allows the listener to
 *             build a portion of the Param.
 *
 * @see        org.jcon.param.util.build.BuildParamEvent
 */
public void processBuildParamEvent(BuildParamEvent evt);


} // End interface

/**

import org.jcon.param.util.build.BuildParamEvent;
import org.jcon.param.util.build.BuildParamListener;

//---------- BuildParamListener Implementation -----------
public String[] getBuildParamKeys() {
    return new String[] {"LookupATSDR"};
}
public void processBuildParamEvent(BuildParamEvent evt) {
    if (evt.getBuildKey().equals("LookupATSDR")) {
        replaceParamText(evt);
    }
}

*/
