package org.jcon.param.util.build;

// import org.jcon.util.GenLib;

/**
 * This class is an event fired when a "BuildParam" is
 * needed. The event contains the getters and setters
 * necessary for the listener to "build" the Param by
 * modifying the Param text.
 *
 * @author Jack Harich
 */
public class BuildParamEvent {

//---------- Public Fields -------------------------------
public static final int REPLACE = 1;

//---------- Private Fields ------------------------------
//----- Properties
private int eventType;
private String replacement;
private String buildKey;
private String buildValue;

//---------- Initialization ------------------------------
public BuildParamEvent(int eventType) {
    this.eventType = eventType;
}
//---------- Properties ----------------------------------
//----- EventType
public int getEventType() {
    return eventType;
}
//----- BuildKey
public void setBuildKey(String buildKey) {
    this.buildKey = buildKey;
}
public String getBuildKey() {
    return buildKey;
}
//----- BuildValue
public void setBuildValue(String buildValue) {
    this.buildValue = buildValue;
}
public String getBuildValue() {
    return buildValue;
}
//----- Replacement
public void setReplacement(String replacement) {
    this.replacement = replacement;
}
public String getReplacement() {
    return replacement;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("BuildParamEvent" + text);
}

} // End class
