package org.jcon.param.tree;

import org.jcon.param.Param;
import org.jcon.param.ParamConverter;
import org.jcon.param.schema.Branch;
import org.jcon.param.schema.BranchSchema;

/**
 * Test converter, etc.  java org.jcon.param.tree.Test
 * 
 * @author Jack Harich
 */
public class TestTreeData {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new TestTreeData().runTest();
}
//---------- Public Methods ------------------------------
public void runTest() {
    testPropListConverter();
    //testSchemaValidation();
}
public void testPropListConverter() {
    //----- toPropList(), print root node tree
    PropList propList = PropListConverter.toPropList(
        createHarichFamilyParam());
    propList.setName("Rootx");
    String list = propList.getRootNode().listTree();
    // Note list.toString() contains only nodes, no End:
    print(" ----- listTree() = \n" + list + "");
    
    // This works fine
    //propList.removeDatum("FathersFamily");
    //list = propList.getRootNode().listTree();
    //print(" ----- After remove = \n" + list + "");

    //----- toParam(), print Param
    Param param = PropListConverter.toParam(propList);
    print(" ----- PropList to Param is:\n" + param);
}
public static Param createHarichFamilyParam() {
    String text =
    "    // This is the houseful of happy Harichs\n" +
    "    BranchName is: Family\n" +
    "    Father is: Fritz\n" +
    "    Children is: Pete, Jack, Willie, Chester\n" +
    "    Pets hasElements:\n" +
    "        // Comments can be interspersed anywhere\n" +
    "        Element:\n" +
    "            Ciggy is: Cat\n" +
    "            Oscar has:\n" +
    "                Lives is: 9\n" +
    "                End: Oscar\n" +        
    "            End: Element\n" + 
    "        End: Pets\n" +
    "    FathersFamily has:\n" +
    "        BranchName is: Family\n" +
    "        // We also have Mom\n" +
    "        Moms hasLines:\n" +
    "            Virginia, Kentucky\n" +
    "            Granny, Kentucky\n" + 
    "            End: Moms\n" +
    "        Father is: Pop\n" +
    "        Children is: Carl, Tesie\n" +
    "        End: FathersFamily";
    return ParamConverter.toParam(text);
}
// Original verions for use with schema testing
public static Param XcreateHarichFamilyParam() {
    String text =
    //"HarichFamily has:\n" +
    "    BranchName is: Family\n" +
    "    Father is: Fritz\n" +
    //"    Father is: Fritz\n" +
    //"    Mother is: Virginia\n" +
    "    Children is: Pete, Jack, Willie, Chester\n" +
    "    FathersFamily has:\n" +
    "        BranchName is: Family\n" +
    "        Father is: Pop\n" +
    //"        Mother is: Mom\n" +
    "        Children is: Carl, Tesie\n" +
    "        End: FathersFamily";
    //"    End: HarichFamily";
    return ParamConverter.toParam(text);
}
public void testSchemaValidation() {

    // Init schema
    BranchSchema schema = new BranchSchema();
    schema.setParam(createSchemaParam());
    schema.addBranchParam(createFamilyPropListBranchParam());

    // Init DatumContext with schema
    //DatumContext context = new DatumContext();
    //context.setSchema(schema);

    // Create Param to validate
    Param param =  createHarichFamilyParam();
    print(" ----- Validating Param:\n" + param + "\n");

    // Create Datum node from Param
    PropList propList = PropListConverter.toPropList(param);
    propList.setName("TestRoot");
    //propList.setDatumContext(context);

    // Get definition to use for validation
    Branch familyBranch = schema.getBranch("Family");

    // Validate
    String okay = familyBranch.validate(propList, true);
    print(" - Validate result = " + okay);
}
public Param createSchemaParam() {

    String text =
    "BranchTypeClasses hasLines:\n" +
    "    PropList, org.jcon.param.schema.PropListBranch\n" +
    "    End: BranchTypeClasses";

    return ParamConverter.toParam(text);
}
public Param createFamilyPropListBranchParam() {

// *** Mod - Add DatumDefFactory, which uses Type to
// create instance, then calls setParam(), which verifies
// the Type = internal type.

    String text =
    "BranchName is: Family\n" +
    "BranchType is: PropList\n" +
    "Properties has:\n" +
    "    Father has:\n" +
    "        DatumType is: Fact\n" +
    "        Required is: true\n" +
    "        ValueType is: Name\n" +
    "        ValueRequired is: true\n" +
    "        End: Father\n" +
    "    Children has:\n" +
    "        DatumType is: Fact\n" +
    "        Required is: true\n" +
    "        ValueType is: DelimitedNames\n" +
    "        End: Children\n" +
    "    FathersFamily has:\n" + // ditto for MothersFamily
    "        DatumType is: PropList\n" + // RECURSE
    "        DefType is: Family\n" +
    "        End: FathersFamily\n" +
    "    End: Properties";

    Param param = ParamConverter.toParam(text);
    param.put("Default", createHarichFamilyParam());
    return param;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TestTreeData" + text);
}

} // End class
