package org.jcon.param.tree;

import org.jcon.util.minor.BetterHashtable;
import java.util.Enumeration;
import java.util.Vector;

/**
 * Represents a container node with a list of properties.
 * The properties may be a Comment, Fact, PropList,
 * LineList or ElementList.
 *
 * @author Jack Harich
 */
public class PropList extends DatumBranch {

//---------- Private Fields ------------------------------
// Maintained in order added.
// Key = name, Object = Datum
private BetterHashtable properties = new BetterHashtable();

// false = normal PropList, true = Element PropList
private boolean isElement; // Default normal PropList

//---------- Abstract Implementation ---------------------
//----- From Datum
// The text to be displayed in the tree
public String toString() {
    if (isElement) {
        return "Element";
    } else {
        return myName + " has:";
    }
}
public void performCommand(DatumCommand command) {
    String name = command.getName();
    print(".performCommand() name = " + name);

    /* if (name == "Validate") { // Now done by 
        validate(true);
    } */
}
//----- From DatumBranch
public Datum insertDatum(String name, Datum datum,
        String relativeName) {
    //print(".addProperty() - Inserting '" + name + "'  " + this);
    return (Datum)properties.insert(name.intern(), datum, relativeName);
}
public Vector getDatums() {
    return properties.getOrderedObjects();
}
public Datum removeDatum(String name) {
    Datum datum = getDatum(name);
    if (datum == null) {
        return null;
    } else {
        datum.removeFromTree();
        properties.remove(name);
        return datum;
    }        
}
//---------- Properties ----------------------------------
public void setActuallyElement(boolean isElement) {
    this.isElement = isElement;
}
public boolean isActuallyElement() {
    return isElement;
}
//---------- Public Methods ------------------------------
// These are for validation
public Datum getDatum(String name) {
    return (Datum)properties.get(name);
}
public Enumeration getDatumNames() {
    return properties.getOrderedKeys(); // Ordered
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("PropList" + text);
}

} // End class
