package org.jcon.param.tree;

import org.jcon.param.StringVector;
import java.util.Enumeration;
import java.util.Vector;

/**
 * Represents a container node with a list of lines.
 *
 * @author Jack Harich
 */
public class LineList extends DatumBranch {

//---------- Private Fields ------------------------------
// Contains Line Datums
private Vector lines = new Vector(); 

//---------- Abstract Implementation ---------------------
//----- From Datum
// The text to be displayed in the tree
public String toString() {
    return myName + " hasLines:";
}
public void performCommand(DatumCommand command) {
    String name = command.getName();
    print(".performCommand() name = " + name);
}
//----- From DatumBranch
/**
* The line name is the vector index, starting at "0".
*
* @return  null, since we renumber lines every time.
*/
public Datum insertDatum(String name, Datum datum,
        String relativeName) {
    //print(".insertDatum() - Inserting '" + name + "'  " + this);
    if (! (datum instanceof Line)) throw new IllegalArgumentException(
        "LineList can only contain Lines. The datum is a '" + datum.getClass() );
        
    if (relativeName == null) {
        lines.addElement(datum);
        renumberLines();
    } else {
        // Name is index to insert before
        int index = Integer.valueOf(name).intValue();
        lines.insertElementAt(datum, index);
        renumberLines();
    }
    return null;
}
public Vector getDatums() {
    return lines;
}
public Datum removeDatum(String name) {
    Line line = getLine(name);
    if (line == null) {
        return null;
    } else {
        line.removeFromTree();
        lines.removeElement(line);
        renumberLines();
        return (Datum)line;
    }        
}
//---------- Public Methods ------------------------------
public void setLines(StringVector newLines) {
    lines.removeAllElements();
    int size = newLines.size();
    for (int i = 0; i < size; i++) {    
        String name = String.valueOf(i);
        String text = (String)newLines.elementAt(i);
        lines.addElement(createLine(name, text));
    }
}
// Returns StringVector of Strings, one per line
// This is the opposite of setLines()
public StringVector createStringVector() {
    StringVector newLines = new StringVector();
    int size = lines.size();
    for (int i = 0; i < size; i++) {
        Line line = (Line)lines.elementAt(i);
        newLines.addElement(line.getValue());
    }
    return newLines;
}
//---------- Private Methods -----------------------------
private void renumberLines() {
    for (int i = 0; i < lines.size(); i++) {
        Line line = (Line)lines.elementAt(i);
        line.setName(String.valueOf(i));
    }
}
// Returns null if not found
private Line getLine(String name) {
    for (int i = 0; i < lines.size(); i++) {
        Line line = (Line)lines.elementAt(i);
        if (line.getName().equals(name)) return line;
    }
    return null; // Not found
}
private Line createLine(String name, String text) {
    Line line = new Line();
    line.setName(name);
    line.setParentDatum(this);
    line.setValue(text);
    return line;
}
//--- Std
private static void print(String text) {
    System.out.println("LineList" + text);
}

} // End class
