package org.jcon.param.tree;

import java.util.Enumeration;
import java.util.Vector;

/**
 * Represents a container node with a list of PropLists
 * and Comments. All PropLists have the same name "Element".
 * The Comments are before, between and after the PropLists.
 *
 * @author Jack Harich
 */
public class ElementList extends DatumBranch {

//---------- Private Fields ------------------------------
// Contains PropLists and Comments
private Vector items = new Vector();

//---------- Abstract Implementation ---------------------
//----- From Datum
// The text to be displayed in the tree
public String toString() {
    return myName + " hasElements:";
}
public void performCommand(DatumCommand command) {
    String name = command.getName();
    print(".performCommand() name = " + name);
}
//----- From DatumBranch
/**
* The name is the vector index, starting at "0". If the
* relativeName is null, then the name is irrelevant since
* the datum is inserted at the end. This is done for
* internal integrity.
*
* @return  null, since we renumber every time.
*/
public Datum insertDatum(String name, Datum datum,
        String relativeName) {
    //print(".insertDatum() - Inserting '" + name + "'  " + this);
    // Assertions, minor fiddling
    if (datum instanceof PropList) {
        ((PropList)datum).setActuallyElement(true);
    } else if (datum instanceof Comment) {
        // Do nothing
    } else {
        throw new IllegalArgumentException(
            "ElementList can only contain PropLists or Comments. The datum is a '" + datum.getClass() );
    }
    // Insert
    if (relativeName == null) {
        String newLastIndex = String.valueOf(items.size());
        datum.setName(newLastIndex); 
        items.addElement(datum);
    } else {
        // Name is index to insert before
        int index = Integer.valueOf(name).intValue();
        items.insertElementAt(datum, index);
        renumberItems();
    }
    return null;
}
public Vector getDatums() {
    return items;
}
public Datum removeDatum(String name) {
    Datum datum = getDatum(name);
    if (datum == null) {
        return null;
    } else {
        datum.removeFromTree();
        items.removeElement(datum);
        renumberItems();
        return datum;
    }        
}
//---------- Public Methods ------------------------------
// Returns Vector of PropLists and Comments, one per item
public Vector createVector() {
    return items;
}
//---------- Private Methods -----------------------------
private void renumberItems() {
    for (int i = 0; i < items.size(); i++) {
        Datum item = (Datum)items.elementAt(i);
        item.setName(String.valueOf(i));
    }
}
// Returns null if not found
private Datum getDatum(String name) {
    for (int i = 0; i < items.size(); i++) {
        Datum item = (Datum)items.elementAt(i);
        if (item.getName().equals(name)) return item;
    }
    return null; // Not found
}
//--- Std
private static void print(String text) {
    System.out.println("ElementList" + text);
}

} // End class
