package org.jcon.param.tree;

/**
 * Represents a leaf node in a data hierarchy.
 *
 * @author Jack Harich
 */
public abstract class DatumLeaf extends Datum {

//---------- Private Fields ------------------------------
protected String myValue;

//---------- Initialization ------------------------------
public DatumLeaf() {
    super();
    node.setAllowsChildren(false);
}
//---------- Abstract Implementation ---------------------
public final boolean isLeaf() {
    return true;
}
// Note we do not implement abstract toString()

//---------- Public Methods ------------------------------
public void setValue(String value) {
    myValue = value;
}
public String getValue() {
    return myValue;
}    


} // End class
