package org.jcon.param.tree;

import java.util.Hashtable;

/**
 * Supplies the services a Datum may use. This approach
 * prevents adding many methods to Datum just to supply
 * each Datum with services. It also allows greater
 * subsystem reuse.
 *
 * @author Jack Harich
 */
public class DatumContext {

//---------- Private Fields ------------------------------
//private BranchSchema schema;

// Key = name, Object = Object to be cast by client
private Hashtable services = new Hashtable();

//---------- Properties ----------------------------------
//----- schema
/* public void setSchema(BranchSchema schema) {
    this.schema = schema;
}
public BranchSchema getSchema() {
    return schema;
} */
//----- services
public Object putService(String name, Object service) {
    return services.put(name.intern(), service);
}
public Object getService(String name) {
    return services.get(name);
}
//---------- Public Methods ------------------------------

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("DatumContext" + text);
}

} // End class
