package org.jcon.param.tree;

// import org.jcon.util.GenLib;

/**
 * Represents an order for a Datum to perform a command.
 * Contains the properties needed to determine what to do
 * and in some cases the data needed to do it. This is an
 * extensible approach that keeps the
 * Datum.performCommand() method stable.
 *
 * @author Jack Harich
 */
public class DatumCommand {

//---------- Private Fields ------------------------------
private String name;

//---------- Initialization ------------------------------
public DatumCommand(String name) {
    this.name = name.intern();
}
//---------- Properties ----------------------------------
/**
 * Returns the interned command name, such as AddPropList,
 * MoveUp or Paste.
 */
public String getName() {
    return name;
}
// *** More later

//---------- Public Methods ------------------------------

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("DatumCommand" + text);
}

} // End class
